#include <stdio.h>
#include <stdint.h>

static inline void write_pmevtyper0(uint64_t v){ asm volatile("msr pmevtyper0_el0, %0" :: "r"(v)); }
static inline void write_pmevcntr0(uint64_t v){ asm volatile("msr pmevcntr0_el0, %0" :: "r"(v)); }
static inline uint64_t read_pmevcntr0(void){ uint64_t v; asm volatile("mrs %0, pmevcntr0_el0" : "=r"(v)); return v; }
static inline void pmu_enable(void){
    /* PMCR_EL0: E(Enable)=1, P(reset event cnts)=1, C(reset cycle)=1 */
    asm volatile("msr pmcr_el0, %0" :: "r"(0x17ull));
    /* Enable counter 0 */
    asm volatile("msr pmcntenset_el0, %0" :: "r"(1ull << 0));
}

int main(void)
{
    /* イベント: 0x08 = Instructions retired (AArch64 の代表例) */
    write_pmevtyper0(0x08);
    write_pmevcntr0(0);
    pmu_enable();

    /* 計測対象のループ */
    for (volatile int i = 0; i < 1000000; i++) { }

    uint64_t cnt = read_pmevcntr0();
    printf("PMEVCNTR0 (instructions retired): %llu\n",
           (unsigned long long)cnt);
    return 0;
}
