# Tang Primer 25K : signal_proc_with_adc_dac
## 概要
* `FPGAデザイン集 : 第2部第1章 (FFT IP コアを使ってディジタル・フィルタを設計する)` のビルド環境一式
* Tang Primer 25Kに以下の機能を実装している
   1. アナログ信号入力: SPI A-Dコンバータから一定レートでサンプリング
   2. 信号処理: FFT -> 周波数スペクトル値加工 -> IFFT による周波数フィルタ処理 (FFT/IFFTは2048点)
   3. アナログ信号出力: フィルタ処理済み信号を SPI D-Aコンバータに一定レートで出力
* A-D コンバータ / D-Aコンバータ モジュールは以下を想定
   * A-Dコンバータモジュール = Digilent Pmod AD1 (PMOD J4コネクタに接続)
   * D-Aコンバータモジュール = Digilent Pmod DA2 (PMOD J5コネクタに接続)


## 注意事項
* 本デザイン中で使用しているIPコアは, 設定ファイル(.ipc)のみを格納している。
    * **後述の手順でソースコード生成が必要。**


## 動作確認環境
* OS: Ubuntu 22.04.4
* Gowin FPGA Designer: Version V1.9.11.03 Education build(81398)
   * 通常(非Education)版も使用可能
* openFPGALoader: https://github.com/trabucayre/openFPGALoader (commit:08f5072)
   * FPGAへの書き込みに Gowin Programmer を用いる場合, openFPGALoader は不要


## ビルド方法
#### 1. 環境変数の設定
* 環境変数 "PATH" に Gowin IDE の `bin` ディレクトリへのパスを設定する

```bash
# 設定例
$ export PATH=$PATH:/<...>/Gowin_V1.9.11.03_Education_Linux/IDE/bin
```

#### 2. IPコアのソースコード生成
下表の4個のIPコアについて, Gowin FPGA Designer を用いて .ipc ファイルからソースコードを生成する必要がある.

| 名前         | ipcファイル                              | 備考                  | 
| ---          | ---                                      | ---                   |
| fft          | src/ipcore/fft/fft.ipc                   | FFT                   |
| ifft         | src/ipcore/ifft/ifft.ipc                 | IFFT                  |
| fifo_real    | src/ipcore/fifo_real/fifo_real.ipc       | 12Bit 実数値用 FIFO   |
| fifo_complex | src/ipcore/fifo_complex/fifo_complex.ipc | 12Bit 複素数値用 FIFO |

1. Gowin FPGA Designerを起動し, GUI画面上部メニューの `Tools > IP Core Generator` を選択

2. "Target Device:" の右側をクリックし、"GW5A-LV25MG121NC1/l0" (Device Version: A) を選択

3. Target Device:" のさらに右側にあるファイルアイコンをクリックし、上表に示したipcファイルを開く

4. IPコアの設定ウィンドウが開くので、そのまま "OK" ボタンをクリックする
   * 正常に完了すると、ipcファイルと同じフォルダに以下のファイルが生成される
      * `<名前>.v` / `<名前>.vo` / `<名前>_tmp.v`

5. 1~4の手順を、上表の4個のipcファイル全てに対して行う

![1.IP Core Generatorの起動](./doc/ipc_gen_start.drawio.svg)

![2.Target Deviceの設定 / 3. ipcファイルのオープン](./doc/ipc_gen_sel_device_open_ipc.drawio.svg)

#### 3. 周波数フィルタ係数の設定
* 本デザインでは, 周波数フィルタの係数はビルド時に静的設定なので, 事前に所望の値に編集する
* ソースファイル: `src/freq_filter_coef_com.sv`
   * `coef_rom[0]` ~ `coef_rom[1024]` の値を編集する
   * 1要素が周波数領域データの1Binに対応している
   * 設定値は 整数部4Bit + 小数部4Bit (計8Bit) の符号無し固定小数点値


#### 4. プロジェクト復元と合成

```bash
$ make build
```

* 正常に完了すると、以下のファイルが生成される
   * Gowin FPGA Designer プロジェクトファイル: `./signal_proc_with_adc_dac.gprj`
   * ビットストリームファイル: `./impl/pnr/signal_proc_with_adc_dac.fs`


## FPGAへの書き込み方法
### openFPGALoader を用いる場合

```bash
$ make writefpga
```

### Gowin Programmer を用いる場合
* Gowin Programmer でビットストリームファイル (`./impl/pnr/signal_proc_with_adc_dac.fs`) を指定して書き込む

