# 使用する変数
set PRJ_NAME "signal_proc_with_adc_dac"
set PART_NUM "GW5A-LV25MG121NC1/I0"
set DEV_VER "A"
set SRC_FILES {"./src/signal_proc_with_adc_dac_top.sv"
               "./src/SPI_MASTER.sv"
               "./src/spi_adc_sampling.sv"
               "./src/spi_dac_output.sv"
               "./src/signal_processing.sv"
               "./src/freq_filter.sv"
               "./src/freq_filter_coef_rom.sv"
               "./src/ipcore/fft/fft.v"
               "./src/ipcore/ifft/ifft.v"
               "./src/ipcore/fifo_real/fifo_real.v"
               "./src/ipcore/fifo_complex/fifo_complex.v"
              }
set CST_FILES {"./src/signal_proc_with_adc_dac.cst"}
set SDC_FILES {"./src/signal_proc_with_adc_dac.sdc"}

# プロジェクトを作成
create_project -dir ../ \
               -name $PRJ_NAME \
               -pn $PART_NUM \
               -device_version $DEV_VER \
               -force

# System Verilog 2017 を使用することを指定
set_option -verilog_std sysv2017

# 各種ピンをGPIO として指定
set_option -use_cpu_as_gpio true

# ソースファイルを指定
foreach SRC_FILE $SRC_FILES {
  add_file -type verilog [file normalize $SRC_FILE]
}
# 物理制約ファイルを指定
foreach CST_FILE $CST_FILES {
  add_file -type cst [file normalize $CST_FILE]
}
# タイミング制約ファイルを指定
foreach SDC_FILE $SDC_FILES {
  add_file -type sdc [file normalize $SDC_FILE]
}

# 論理合成、配置配線、ビットストリーム生成を実行
run all
