module signal_proc_with_adc_dac_top(
    input wire clk,      // クロック入力 (50 MHz)
    input wire rst_btn,  // Reset ボタン入力

    // SPI IF for ADC (入力(MISO)のみ)
    output logic adc_spi_sclk,
    output logic adc_spi_ncs,
    input  wire  adc_spi_miso,

    // SPI IF for DAC (出力(MOSI)のみ)
    output logic dac_spi_sclk,
    output logic dac_spi_ncs,
    output logic dac_spi_mosi
);
    // ボタン入力(正極性)を反転させてリセット信号(負極性)を生成
    wire nrst = ~rst_btn;

    // SPI ADC 入力モジュール
    parameter sampling_interval = 250;
    logic adc_dout_valid;
    logic adc_dout_ready;
    logic [11:0] adc_dout_data;

    spi_adc_sampling spi_adc_sampling_inst(
        .clk(clk),
        .nrst(nrst),
        .sampling_inverval(sampling_interval), // サンプリング周期 (単位:クロックサイクル)
        .adc_spi_sclk(adc_spi_sclk), 
        .adc_spi_ncs(adc_spi_ncs),
        .adc_spi_miso(adc_spi_miso),  
        .dout_valid(adc_dout_valid),
        .dout_ready(adc_dout_ready),
        .dout_data(adc_dout_data)
    );

    // 符号無し(0 ~ 4095) -> 符号付き(-2048 ~ 2047) 変換 
    logic [11:0] adc_dout_data_shifted;
    always_comb begin
        adc_dout_data_shifted = adc_dout_data - 12'd2048;
    end   

    // 信号処理モジュール
    logic signal_proc_dout_valid;
    logic signal_proc_dout_ready;
    logic [11:0] signal_proc_dout_data;

    signal_processing # ( .INPUT_BITS(12), .OUTPUT_BITS(12) ) signal_processing_inst (
        .clk(clk),
        .nrst(nrst),
        .din_valid(adc_dout_valid),
        .din_ready(adc_dout_ready),
        .din_data(adc_dout_data_shifted),
        .dout_valid(signal_proc_dout_valid),
        .dout_ready(signal_proc_dout_ready),
        .dout_data(signal_proc_dout_data)
    );

    // 符号付き(-2048 ~ 2047) -> 符号無し(0 ~ 4095) 変換 
    logic [11:0] signal_proc_dout_data_shifted;
    always_comb begin
        signal_proc_dout_data_shifted = signal_proc_dout_data + 12'd2048;
    end   

    // SPI DAC 出力モジュール
    spi_dac_output spi_dac_output_inst(
        .clk(clk),
        .nrst(nrst),
        .output_inverval(sampling_interval),
        .dac_spi_sclk(dac_spi_sclk), 
        .dac_spi_ncs(dac_spi_ncs),  
        .dac_spi_mosi(dac_spi_mosi),
        .din_valid(signal_proc_dout_valid),
        .din_ready(signal_proc_dout_ready),
        .din(signal_proc_dout_data_shifted)
    );

endmodule
